<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserBrach extends Model 
{

    protected $table = 'user_branch';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'user_id', 'updated_by', 'created_by');

    public function branchs()
    {
        return $this->hasMany('App\Models\Bransh', 'branch_id');
    }

    public function users()
    {
        return $this->hasMany('App\Models\User', 'user_id');
    }

}